/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.flex;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

import intrinsic.mx.collections.ICollectionView;
import intrinsic.mx.controls.menuClasses.IMenuDataDescriptor;

public class SWTMenuDataDescriptor implements IMenuDataDescriptor {
/*+
  public function addChildAt(arg0: Object, arg1: Object, arg2: int, arg3: Object = null): Boolean {
    return _addChildAt(arg0, arg1, arg2, arg3);
  }
  public function getChildren(arg0: Object, arg1: Object = null): ICollectionView {
    return _getChildren(arg0, arg1);
  }
  public function getData(arg0: Object, arg1: Object = null): Object {
    return _getData(arg0, arg1);
  }
  public function hasChildren(arg0: Object, arg1: Object = null): Boolean {
    return _hasChildren(arg0, arg1);
  }
  public function isBranch(arg0: Object, arg1: Object = null): Boolean {
    return _isBranch(arg0, arg1);
  }
  public function removeChildAt(arg0: Object, arg1: Object, arg2: int, arg3: Object = null): Boolean {
    return _removeChildAt(arg0, arg1, arg2, arg3);
  }
+*/

public boolean _addChildAt(Object parent, Object newChild, int index, Object arg3) {
	return false;
}

public ICollectionView _getChildren(Object node, Object model) {
	if (node == null) return null;
	MenuItem item = (MenuItem)node;
	Menu menu = item.getMenu();
	if (menu != null) {
		return menu.items;
	}
	return null;
}

public Object _getData(Object node, Object model) {
	return node;
}

public String getGroupName(Object node) {
	return "";
}

public String getType(Object node) {
	if (node == null) return "normal";
	MenuItem item = (MenuItem)node;
	int style = item.getStyle();
	if ((style & SWT.RADIO) != 0) return "radio";
	if ((style & SWT.CHECK) != 0) return "check";
	if ((style & SWT.SEPARATOR) != 0) return "separator";
	return "normal";
}

public boolean _hasChildren(Object node, Object model) {
	if (node == null) return false;
	MenuItem item = (MenuItem)node;
	Menu menu = item.getMenu();
	if (menu != null) {
		return menu.items.length != 0;
	}
	return false;
}

public boolean _isBranch(Object node, Object model) {
	return _hasChildren(node, model);
}

public boolean isEnabled(Object node) {
	if (node == null) return false;
	MenuItem item = (MenuItem)node;
	return item.isEnabled ();
}

public boolean isToggled(Object node) {
	if (node == null) return false;
	MenuItem item = (MenuItem)node;
	return item.getSelection ();
}

public boolean _removeChildAt(Object parent, Object arg1, int arg2, Object model) {
	return false;
}

public void setEnabled(Object node, boolean value) {
	if (node == null) return;
	MenuItem item = (MenuItem)node;
	item.setEnabled (value);
}

public void setToggled(Object node, boolean value) {
	if (node == null) return;
	MenuItem item = (MenuItem)node;
	item.setSelection (value);
}

}
